              
/*****************************************************************************
*                           Freescale Semiconductor                          *
*                   Brazilian Semiconductor Tecnology Center                 *
*                                                                            *
*  Project    : MC56F8006 Modular Pixel Matrix                               *
*  Version    : 0.1                                                          *
*  Date       : 16/Apr/2009                                                  *
*  Engineers  : Alexandre Dias, Bruno Bastos                                 *
*               Humberto Carvalho, Leonardo Mangiapelo                       *
*               Renato Frias                                                 *
*                                                                            *
* -------------------------------------------------------------------------- *
*  Description:                                                              *
*                                                                            *
*    MC56F8006 SCI															 * 
*                                                                            *
******************************************************************************/

/************************* Project Include Files *****************************/

#include "LIB_SCI.h"
#include "MC56f8006.h"

typedef unsigned char byte;

/****************************** Prototypes ***********************************/

/**
 * TERMIO_PutChar:   This function sends a character through the SPI. 
 *
 * Parameters:    character to be sent
 *
 * Subfunctions:  none.
 *
 * Return:        void
 */ 
void TERMIO_PutChar(int8_t send) 
{
  int8_t dummy;
  
  while(!(SCI_STAT & SCI_STAT_TDRE)){}
  
  	
  
  dummy = SCI_STAT;
  SCI_DATA  = send;    
}//end TERMIO_PutChar


/**
 * TERMIO_GetChar:   This function receives a character through the SPI 
 *
 * Parameters:    none
 *
 * Subfunctions:  none.
 *
 * Return:        character recieved
 */ 

int8_t TERMIO_GetChar(void) 
{
  int8_t dummy, teste;
  byte rec_char;
  
  if (SCI_STAT_RDRF)  // 1st half of RDRF clear procedure
    rec_char = SCI_DATA; 
  
  SCI_CTRL1|=SCI_CTRL1_RE;
  
  while(! (SCI_STAT & SCI_STAT_RDRF)){}
  dummy = SCI_STAT;
  teste=SCI_DATA;
  TERMIO_PutChar(teste);
  
  return SCI_DATA;  
} //end TERMIO_GetChar 


/**
 * TERMIO_Print:   This function sends a character string ended with 0 through the SCI
 *
 * Parameters:    character to be sent
 *
 * Subfunctions:  none.
 *
 * Return:        void
 */ 
void TERMIO_Print(int8_t * str ) 
{ 
	uint8_t dummy;
	
	while(*str) 
	{
	  while( !(SCI_STAT & SCI_STAT_TDRE) ){}
	 // dummy = SCI_STAT;
	  SCI_DATA  = *str++;    		
	}
  
}//end TERMIO_PutChar


/**
 * TERMIO_PrintDigit:   This function sends a digit number through the SCI
 *
 * Parameters:    number to be sent
 *
 * Subfunctions:  none.
 *
 * Return:        void
 */ 
void TERMIO_PrintDigit(uint16_t number  ) 
{ 
	uint8_t dummy;
	uint8_t buf[4];
	int8_t  i = 0;
	
	for(i = 0; i < 4; i++)
	{
		buf[i] = (number>>(i<<2)) & 0x000f;
		if(buf[i] >= 0 && buf[i] <= 9)
		{
			buf[i] += '0';
		}
		if(buf[i] >= 0x0a && buf[i] <= 0x0f)
		{
			buf[i] += ('A'-0x0a);
		}			
	}
	
	for( i = 3; i >= 0; i--) 
	{
	  while( !(SCI_STAT & SCI_STAT_TDRE) ){}
	  //dummy = SCI_STAT;
	  SCI_DATA  = buf[i];    		
	}
  
}//end TERMIO_Printdigit

/**
 * TERMIO_Init: This function initial the terminal. 
 *
 * Parameters:             void
 *
 * Subfunctions:           none.
 *
 * Return:                 void
 */ 

#pragma interrupt alignsp called
void TERMIO_Init(uint32_t baudrate) 
{
	uint16_t	sbr;
	uint8_t	frac_sbr;
	
	/* Configure GPIOB6 and GPIOB7 as RXD and TXD */
	SIM_GPSB1 = 0;
	GPIOB_PER |= (GPIOB_PER_PER_6 | GPIOB_PER_PER_7);
	
	/* Enable clock to SCI */
	SIM_PCE |= SIM_PCE_SCI;
	
	sbr = (SCI_CLOCK_HZ>>4)/ baudrate;
	frac_sbr = ((SCI_CLOCK_HZ>>1)/baudrate - (sbr<<3)) & 0x7;
	SCI_RATE = (sbr<<3) | frac_sbr;
	
	#if 0 
	sSCI_CTRL1.TE = 1;		/* WARN: compiler uses little endian mode for structure
	                         *       but here the structure is defined as big endian mode
	                         */
	sSCI_CTRL1.RE = 1;	
	#endif
	SCI_CTRL1 = (SCI_CTRL1_TE | SCI_CTRL1_RE);
		
}//end TERMIO_Init








